/*
 * Decompiled with CFR 0.152.
 */
package AccuServerConnector;

import AccuServerBase.AccuServerHostConnectorBase;
import AccuServerBase.ServerCore;
import AccuServerBase.ServerObject;
import AccuServerConnector.HostRequestHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class AccuServerHostConnector
implements ServerObject,
AccuServerHostConnectorBase {
    HostWebSocket webSocket = null;
    ServerCore core = null;
    String webSocketUri = "wss://host.accupos.com:40000";
    String serialNumber = null;
    String machineId = null;
    boolean connected = false;
    boolean disableRetry = false;
    boolean delayRetry = false;

    public void initialize(ServerCore core, Hashtable parameters) {
        this.core = core;
        String uri = null;
        if (parameters != null) {
            uri = (String)parameters.get("Uri");
        }
        if (uri != null) {
            this.webSocketUri = uri;
        }
        StartHostWebSocketClient clientThread = new StartHostWebSocketClient(core);
        clientThread.start();
    }

    public void output(String output) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void send(String message) {
        if (message.contains("HostConnectionRefused")) {
            this.core.input("Disabling Host Connection Retry because Connection was Refused");
            this.disableRetry = true;
            try {
                this.webSocket.close();
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        } else if (message.contains("HostConnectionDisabled")) {
            this.core.input("Deactivating Host Connection Retry because Connection was Disabled");
            this.disableRetry = true;
            try {
                this.webSocket.close();
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        } else if (message.contains("HostConnectionDelayed")) {
            this.core.input("Delaying Host Connection Retry for 1 hour");
            this.delayRetry = true;
            this.startDelayedConnectionResetThread();
            try {
                this.webSocket.close();
            }
            catch (Exception e) {
                this.core.raiseException(e);
            }
        } else if (this.connected) {
            this.webSocket.send(message);
        }
    }

    private String getServerDeviceId() {
        String deviceId = "";
        String sysdir = System.getenv("WINDIR");
        Path file = Paths.get(sysdir, new String[0]);
        try {
            BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            FileTime created = attr.creationTime();
            long createdLong = created.toMillis();
            deviceId = "" + createdLong;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return deviceId;
    }

    public void restartHostWebSocketClient() {
        String thisUri = this.webSocketUri + "/" + this.core.getSerialNumber() + "/" + this.getServerDeviceId();
        this.startHostWebSocketClient();
    }

    public void startHostWebSocketClient() {
        if (this.delayRetry) {
            return;
        }
        while (!this.connected) {
            block19: {
                try {
                    String thisUri = this.webSocketUri + "/" + this.serialNumber + "/" + this.machineId;
                    this.webSocket = new HostWebSocket(new URI(thisUri));
                    String storeType = "JKS";
                    String storePassword = "abouttime";
                    String keyPassword = "abouttime";
                    KeyStore trustStore = KeyStore.getInstance(storeType);
                    FileInputStream trustStoreStream = new FileInputStream(System.getProperty("user.dir") + "/truststore.ts");
                    FileInputStream keyStoreStream = new FileInputStream(System.getProperty("user.dir") + "/keystore.jks");
                    trustStore.load(keyStoreStream, storePassword.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(trustStore, keyPassword.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(trustStore);
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    trustStore.load(trustStoreStream, "abouttime".toCharArray());
                    trustManagerFactory.init(trustStore);
                    SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                    sslContext.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                    SSLSocketFactory factory = sslContext.getSocketFactory();
                    this.webSocket.setSocket(factory.createSocket());
                    if (!this.webSocket.connectBlocking()) {
                        if (!this.connected) {
                            this.core.input(String.format("Could not establish connection with the AccuServerCloud on %s", thisUri));
                        }
                    } else {
                        this.connected = true;
                        this.core.input(String.format("Connected with the AccuServerCloud on %s", thisUri));
                        this.core.setHostConnector((AccuServerHostConnectorBase)this);
                    }
                }
                catch (URISyntaxException e) {
                    this.core.input("The given URI for the proxy server is invalid");
                }
                catch (KeyStoreException e) {
                    this.core.input("Could not load the key store for a secure connection with the proxy server");
                }
                catch (UnknownHostException e) {
                    this.core.input(String.format("Could not establish connection with AccuServerHost on %s", this.webSocketUri + "/" + this.serialNumber + "/" + this.machineId));
                }
                catch (IOException e) {
                    if (e.getMessage().contains("Connection refused: connect")) {
                        this.core.input(String.format("Could not establish connection with AccuServerHost on %s", this.webSocketUri + "/" + this.serialNumber + "/" + this.machineId));
                    } else {
                        this.core.input("Could not load the key store file for a secure connection with the proxy server");
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    this.core.input("Invalid encryption algorithm for secure connection with the proxy server");
                }
                catch (CertificateException e) {
                    this.core.input("Invalid certificate for a secure connection with the proxy server");
                }
                catch (UnrecoverableKeyException e) {
                    this.core.input("Unrecoverablel key for a secure connection with the proxy server");
                }
                catch (KeyManagementException e) {
                    this.core.input("Unable to load key store management for a secure connection with the proxy server");
                }
                catch (InterruptedException e) {
                    if (e.getMessage().contains("Connection refused: connect")) break block19;
                    this.core.input("Connection with secure proxy server interrupted");
                }
            }
            if (this.connected) continue;
            this.core.input("Starting AccuServerHost connection retry");
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {}
        }
    }

    void startDelayedConnectionResetThread() {
        DelayedConnectionResetThread delayedConnectionResetThread = new DelayedConnectionResetThread();
        delayedConnectionResetThread.start();
    }

    class DelayedConnectionResetThread
    extends Thread {
        DelayedConnectionResetThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(3600000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AccuServerHostConnector.this.disableRetry = false;
        }
    }

    class StartHostWebSocketClient
    extends Thread {
        ServerCore core = null;

        public StartHostWebSocketClient(ServerCore core) {
            this.core = core;
        }

        @Override
        public void run() {
            boolean done = false;
            String serial = "";
            String deviceId = "";
            while (!done) {
                if (!this.core.isRegistered()) continue;
                serial = this.core.getSerialNumber();
                deviceId = AccuServerHostConnector.this.getServerDeviceId();
                done = !serial.isEmpty() && !deviceId.isEmpty();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            AccuServerHostConnector.this.serialNumber = serial;
            AccuServerHostConnector.this.machineId = deviceId;
            AccuServerHostConnector.this.startHostWebSocketClient();
        }
    }

    class HostWebSocket
    extends WebSocketClient {
        public HostWebSocket(URI serverUri) {
            super(serverUri);
            this.setConnectionLostTimeout(0);
            this.setConnectionLostTimeout(300);
        }

        public void onOpen(ServerHandshake sh) {
            AccuServerHostConnector.this.connected = true;
            System.out.println("AccuServer on open");
        }

        public void onMessage(String message) {
            HostRequestHandler handler = new HostRequestHandler(AccuServerHostConnector.this.core, AccuServerHostConnector.this.serialNumber, AccuServerHostConnector.this.machineId, message);
            handler.start();
        }

        public void onClose(int i, String string, boolean bln) {
            if (!AccuServerHostConnector.this.connected) {
                return;
            }
            AccuServerHostConnector.this.connected = false;
            AccuServerHostConnector.this.core.disableHostSync();
            AccuServerHostConnector.this.core.addToLog("AccuServerHost connection lost");
            while (!AccuServerHostConnector.this.connected && !AccuServerHostConnector.this.disableRetry) {
                if (AccuServerHostConnector.this.delayRetry) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                AccuServerHostConnector.this.core.addToLog("Retrying AccuServerHost connection every 15 seconds");
                try {
                    for (int time = 60000; time > 0; time -= 15000) {
                        Thread.sleep(15000L);
                        if (AccuServerHostConnector.this.connected || AccuServerHostConnector.this.disableRetry) {
                            return;
                        }
                        AccuServerHostConnector.this.restartHostWebSocketClient();
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        public void onError(Exception excptn) {
            try {
                String exceptionClass = excptn.getClass().toString();
                if (excptn.getMessage().contains("Connection refused")) {
                    AccuServerHostConnector.this.core.addToLog(String.format("Could not establish connection with AccuServerHost on %s - Connection refused", AccuServerHostConnector.this.webSocketUri + "/" + AccuServerHostConnector.this.serialNumber + "/" + AccuServerHostConnector.this.machineId));
                    AccuServerHostConnector.this.core.addToLog("Retrying AccuServerHost connection in 1 minute");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                } else if (excptn.getMessage().contains("Connection timed out")) {
                    AccuServerHostConnector.this.core.addToLog(String.format("Could not establish connection with AccuServerHost on %s - Connection timed out", AccuServerHostConnector.this.webSocketUri + "/" + AccuServerHostConnector.this.serialNumber + "/" + AccuServerHostConnector.this.machineId));
                    AccuServerHostConnector.this.core.addToLog("Retrying AccuServerHost connection in 1 minute");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                } else if (excptn.getMessage().contains("Socket closed")) {
                    AccuServerHostConnector.this.core.addToLog(String.format("Could not establish connection with AccuServerHost on %s - Socket was already closed", AccuServerHostConnector.this.webSocketUri + "/" + AccuServerHostConnector.this.serialNumber + "/" + AccuServerHostConnector.this.machineId));
                    AccuServerHostConnector.this.core.addToLog("Retrying AccuServerHost connection in 1 minute");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                } else if (exceptionClass.contains("UnknownHostException")) {
                    AccuServerHostConnector.this.core.addToLog(String.format("Could not establish connection with AccuServerHost on %s - UnknownHostException", AccuServerHostConnector.this.webSocketUri + "/" + AccuServerHostConnector.this.serialNumber + "/" + AccuServerHostConnector.this.machineId));
                    AccuServerHostConnector.this.core.addToLog("Retrying AccuServerHost connection in 1 minute");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {}
                } else {
                    AccuServerHostConnector.this.core.raiseException(excptn);
                    AccuServerHostConnector.this.core.addToLog("Uncaught AccuPOS Host Exception: " + excptn.getMessage());
                    AccuServerHostConnector.this.core.addToLog("Retrying AccuServerHost connection in 1 minute");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Exception e) {
                AccuServerHostConnector.this.core.raiseException(e);
                AccuServerHostConnector.this.core.addToLog("Uncaught AccuPOS Host Exception: " + e.getMessage());
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

