/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class Table {
    public int id = 0;
    public String name = "";
    public String room = "";
    public String type = "";
    public int x = 1;
    public int y = 1;
    public int turn = 0;
    public boolean updated = false;

    public Table() {
    }

    public Table(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public Table(String xml) {
        this.name = Utility.getElement("Name", xml);
        this.room = Utility.getElement("RoomName", xml);
        this.type = Utility.getElement("Type", xml);
        this.x = Utility.getIntElement("X", xml);
        this.y = Utility.getIntElement("Y", xml);
        this.turn = Utility.getIntElement("Turn", xml);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<Table>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<RoomName>" + this.room + "</RoomName>");
        xml.append("<Type>" + this.type + "</Type>");
        xml.append("<X>" + this.x + "</X>");
        xml.append("<Y>" + this.y + "</Y>");
        xml.append("<Turn>" + this.turn + "</Turn>");
        xml.append("</Table>");
        return xml.toString();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == null || obj.getClass() != this.getClass()) {
            return result;
        }
        result = this.name.equals(((Table)obj).name) && this.type.equals(((Table)obj).type);
        return result;
    }

    public JSONObject toJson() {
        JSONObject tableJsonObject = new JSONObject();
        try {
            tableJsonObject.put("id", this.id);
            tableJsonObject.put("name", (Object)this.name);
            tableJsonObject.put("room", (Object)this.room);
            tableJsonObject.put("type", (Object)this.type);
            tableJsonObject.put("X", this.x);
            tableJsonObject.put("Y", this.y);
            tableJsonObject.put("turn", this.turn);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return tableJsonObject;
    }

    public Table(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.name = Utility.getJSONString(jsonString.toString(), "name");
        this.room = Utility.getJSONString(jsonString.toString(), "room");
        this.type = Utility.getJSONString(jsonString.toString(), "type");
        this.x = Utility.getJSONInt(jsonString.toString(), "X");
        this.y = Utility.getJSONInt(jsonString.toString(), "Y");
    }
}

