/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;

public class SyncControl {
    public int id;
    public String locationName;
    public String serverAddress;
    public int serverPort;
    public String syncType;
    public Timestamp scheduledSync;
    public String syncStatus;

    public SyncControl() {
    }

    public SyncControl(int xId, String xlocationName, String xServerAddress, int xServerPort, String xsyncType, Timestamp xScheduledSync, String xSyncStatus) {
        this.id = xId;
        this.locationName = xlocationName;
        this.syncType = xsyncType;
        this.scheduledSync = xScheduledSync;
        this.serverAddress = xServerAddress;
        this.serverPort = xServerPort;
        this.syncStatus = xSyncStatus;
    }

    public SyncControl(String xml) {
        this.id = Utility.getIntElement("Id", xml);
        this.locationName = Utility.getElement("LocationName", xml);
        this.serverAddress = Utility.getElement("ServerAddress", xml);
        this.serverPort = Utility.getIntElement("ServerPort", xml);
        this.syncType = Utility.getElement("SyncType", xml);
        long scheduledSyncText = Utility.getLongElement("ScheduledSync", xml);
        if (scheduledSyncText > 0L) {
            this.scheduledSync = new Timestamp(scheduledSyncText);
        }
        this.syncStatus = Utility.getElement("SyncStatus", xml);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<SyncControl>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<LocationName>" + this.locationName + "</LocationName>");
        xml.append("<ServerAddress>" + this.serverAddress + "</ServerAddress>");
        xml.append("<ServerPort>" + this.serverPort + "</ServerPort>");
        xml.append("<SyncType>" + this.syncType + "</SyncType>");
        if (this.scheduledSync != null) {
            xml.append("<ScheduledSync>" + this.scheduledSync.getTime() + "</ScheduledSync>\r\n");
        }
        xml.append("<SyncStatus>" + this.syncStatus + "</SyncStatus>");
        xml.append("</SyncControl>");
        return xml.toString();
    }
}

