/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public class SummaryData {
    public String code = "";
    public String name = "";
    public String description = "";
    public double quantity = 0.0;
    public double total = 0.0;

    public SummaryData() {
    }

    public SummaryData(String xml) {
        this.code = Utility.getElement("Code", xml);
        this.name = Utility.getElement("Name", xml);
        this.description = Utility.getElement("Description", xml);
        this.quantity = Utility.getDoubleElement("Quantity", xml);
        this.total = Utility.getDoubleElement("Total", xml);
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<Summary>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Name>" + this.name + "</Name>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<Quantity>" + this.quantity + "</Quantity>");
        xml.append("<Total>" + this.total + "</Total>");
        xml.append("</Summary>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("code", (Object)this.code);
            jsonObject.put("name", (Object)this.name);
            jsonObject.put("description", (Object)this.description);
            jsonObject.put("quantity", this.quantity);
            jsonObject.put("total", this.total);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

