/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import org.json.JSONException;
import org.json.JSONObject;

public class ProductLine {
    public int id = 0;
    public String description = null;
    public String itemType = null;
    public String salesAccount = " ";
    public boolean taxable = true;
    public String vatCode = "";
    public boolean scale = false;
    public boolean noDiscount = false;
    public boolean isStock = false;
    public boolean serialized = false;
    public boolean noPartialQuantity = false;
    public String choiceGroup = "";
    public String itemCategory = "";
    public String menuKeyPage = "";
    public String buttonColor = "";
    public String keysetName = "";

    public ProductLine() {
    }

    public ProductLine(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.description = Utility.getJSONString(jsonString.toString(), "description");
        this.itemType = Utility.getJSONString(jsonString.toString(), "itemType");
        this.itemCategory = Utility.getJSONString(jsonString.toString(), "itemCategory");
        this.salesAccount = Utility.getJSONString(jsonString.toString(), "salesAccount");
        this.menuKeyPage = Utility.getJSONString(jsonString.toString(), "menuKeyPage");
        this.buttonColor = Utility.getJSONString(jsonString.toString(), "buttonColor");
        this.vatCode = Utility.getJSONString(jsonString.toString(), "vatCode");
        boolean allowDiscounts = Utility.getJSONBoolean(jsonString.toString(), "allowDiscount");
        this.noDiscount = !allowDiscounts;
        this.scale = Utility.getJSONBoolean(jsonString.toString(), "scale");
        this.isStock = Utility.getJSONBoolean(jsonString.toString(), "isStock");
        this.serialized = Utility.getJSONBoolean(jsonString.toString(), "serializable");
        this.taxable = Utility.getJSONBoolean(jsonString.toString(), "taxable");
        this.noPartialQuantity = Utility.getJSONBoolean(jsonString.toString(), "partial");
        this.keysetName = Utility.getJSONString(jsonString.toString(), "keysetName");
    }

    public JSONObject toJson() {
        JSONObject productLineJsonObject = new JSONObject();
        try {
            productLineJsonObject.put("id", this.id);
            productLineJsonObject.put("description", (Object)this.description);
            productLineJsonObject.put("type", (Object)this.itemType);
            productLineJsonObject.put("category", (Object)this.itemCategory);
            productLineJsonObject.put("salesAccount", (Object)this.salesAccount);
            productLineJsonObject.put("choiceGroup", (Object)this.choiceGroup);
            productLineJsonObject.put("menuKeyPage", (Object)this.menuKeyPage);
            productLineJsonObject.put("buttonColor", (Object)this.buttonColor);
            productLineJsonObject.put("allowDiscount", !this.noDiscount);
            productLineJsonObject.put("vatCode", (Object)this.vatCode);
            productLineJsonObject.put("isStock", this.isStock);
            productLineJsonObject.put("scale", this.scale);
            productLineJsonObject.put("serialized", this.serialized);
            productLineJsonObject.put("noPartialQuantity", this.noPartialQuantity);
            productLineJsonObject.put("taxable", this.taxable);
            productLineJsonObject.put("keysetName", (Object)this.keysetName);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return productLineJsonObject;
    }

    public ProductLine(String thisProductLineXml) {
        this.id = Utility.getIntElement("Id", thisProductLineXml);
        this.description = Utility.getElement("Description", thisProductLineXml);
        this.itemType = Utility.getElement("ItemType", thisProductLineXml);
        this.salesAccount = Utility.getElement("SalesAccount", thisProductLineXml);
        this.taxable = Utility.getBooleanElement("Taxable", thisProductLineXml);
        this.vatCode = Utility.getElement("VatCode", thisProductLineXml);
        this.scale = Utility.getBooleanElement("Scale", thisProductLineXml);
        this.noDiscount = Utility.getBooleanElement("NoDiscount", thisProductLineXml);
        this.isStock = Utility.getBooleanElement("IsStock", thisProductLineXml);
        this.serialized = Utility.getBooleanElement("Serialized", thisProductLineXml);
        this.noPartialQuantity = Utility.getBooleanElement("NoPartialQuantity", thisProductLineXml);
        this.choiceGroup = Utility.getElement("ChoiceGroup", thisProductLineXml);
        this.itemCategory = Utility.getElement("ItemCategory", thisProductLineXml);
        this.menuKeyPage = Utility.getElement("MenuKeyPage", thisProductLineXml);
        this.buttonColor = Utility.getElement("ButtonColor", thisProductLineXml);
        this.keysetName = Utility.getElement("KeysetName", thisProductLineXml);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ProductLine>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Description>" + this.description + "</Description>");
        xml.append("<ItemType>" + this.itemType + "</ItemType>");
        xml.append("<SalesAccount>" + this.salesAccount + "</SalesAccount>");
        xml.append("<Taxable>" + this.taxable + "</Taxable>");
        xml.append("<VatCode>" + this.vatCode + "</VatCode>");
        xml.append("<Scale>" + this.scale + "</Scale>");
        xml.append("<NoDiscount>" + this.noDiscount + "</NoDiscount>");
        xml.append("<IsStock>" + this.isStock + "</IsStock>");
        xml.append("<Serialized>" + this.serialized + "</Serialized>");
        xml.append("<NoPartialQuantity>" + this.noPartialQuantity + "</NoPartialQuantity>");
        xml.append("<ChoiceGroup>" + this.choiceGroup + "</ChoiceGroup>");
        xml.append("<ItemCategory>" + this.itemCategory + "</ItemCategory>");
        xml.append("<MenuKeyPage>" + this.menuKeyPage + "</MenuKeyPage>");
        xml.append("<ButtonColor>" + this.buttonColor + "</ButtonColor>");
        xml.append("<KeysetName>" + this.keysetName + "</KeysetName>");
        xml.append("</ProductLine>\r\n");
        return xml.toString();
    }
}

