/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;

public class PricingSetup {
    public int priceColumn = 0;
    public double priceLimit = 0.0;
    public double quantityLimit = 0.0;
    public boolean repriceCheck = false;

    public PricingSetup(int priceColumn, double priceLimit, double quantityLimit, boolean repriceCheck) {
        this.priceColumn = priceColumn;
        this.priceLimit = priceLimit;
        this.quantityLimit = quantityLimit;
        this.repriceCheck = repriceCheck;
    }

    public PricingSetup(String xml) {
        this.priceColumn = Utility.getIntElement("PriceColumn", xml);
        this.priceLimit = Utility.getDoubleElement("PriceLimit", xml);
        this.quantityLimit = Utility.getDoubleElement("QuantityLimit", xml);
        this.repriceCheck = Utility.getBooleanElement("RepriceCheck", xml);
    }

    public PricingSetup(JSONString jsonString) {
        this.priceColumn = Utility.getJSONInt(jsonString.toString(), "defaultPrice");
        this.priceLimit = Utility.getJSONDouble(jsonString.toString(), "priceLimit");
        this.quantityLimit = Utility.getJSONDouble(jsonString.toString(), "quantity");
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<PricingSetup>");
        xml.append("<PriceColumn>" + this.priceColumn + "</PriceColumn>");
        xml.append("<PriceLimit>" + this.priceLimit + "</PriceLimit>");
        xml.append("<QuantityLimit>" + this.quantityLimit + "</QuantityLimit>");
        xml.append("<RepriceCheck>" + this.repriceCheck + "</RepriceCheck>");
        xml.append("</PricingSetup>");
        return xml.toString();
    }
}

