/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import java.sql.Timestamp;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemExtended {
    public String imageUrl = "";
    public String caloriesPer100g = "";
    public String caloriesPerServing = "";
    public String detailedDescription = "";
    public Timestamp imageCreated = null;

    public ItemExtended() {
    }

    public ItemExtended(ItemExtended source) {
        this.imageUrl = source.imageUrl;
        this.caloriesPer100g = source.caloriesPer100g;
        this.caloriesPerServing = source.caloriesPerServing;
        this.detailedDescription = source.detailedDescription;
        this.imageCreated = source.imageCreated;
    }

    public ItemExtended(String thisItemXml) {
        this.imageUrl = Utility.getElement("ImageUrl", thisItemXml);
        this.caloriesPer100g = Utility.getElement("CaloriesPer100g", thisItemXml);
        this.caloriesPerServing = Utility.getElement("CaloriesPerServing", thisItemXml);
        this.detailedDescription = Utility.getElement("DetailedDescription", thisItemXml);
        String imageCreatedDate = Utility.getElement("ImageCreated", thisItemXml);
        this.imageCreated = imageCreatedDate == null || imageCreatedDate.length() == 0 || imageCreatedDate.equals("null") ? null : Timestamp.valueOf(imageCreatedDate);
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ItemExtended>");
        xml.append("<ImageUrl>" + this.imageUrl + "</ImageUrl>");
        xml.append("<CaloriesPer100g>" + this.caloriesPer100g + "</CaloriesPer100g>");
        xml.append("<CaloriesPerServing>" + this.caloriesPerServing + "</CaloriesPerServing>");
        xml.append("<DetailedDescription>" + this.detailedDescription + "</DetailedDescription>");
        xml.append("<ImageCreated>" + this.imageCreated + "</ImageCreated>");
        xml.append("</ItemExtended>\r\n");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("imageUrl", (Object)this.imageUrl);
            jsonObject.put("CaloriesPer100g", (Object)this.caloriesPer100g);
            jsonObject.put("CaloriesPerServing", (Object)this.caloriesPerServing);
            jsonObject.put("DetailedDescription", (Object)this.detailedDescription);
            jsonObject.put("ImageCreated", (Object)this.imageCreated);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

