/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class FollowOn {
    public String code = "";
    public String type = "";
    public boolean isItem = true;
    public boolean ask = false;
    public ArrayList items = null;
    public int quantity = 0;
    public String description = "";
    public String itemCode = "";

    public FollowOn() {
    }

    public FollowOn(String code, String type, boolean isItem, boolean ask, String itemCode, String description, int quantity) {
        this.code = code;
        this.type = type;
        this.isItem = isItem;
        this.ask = ask;
        this.itemCode = itemCode;
        this.description = description;
        this.quantity = quantity;
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<FollowOn>");
        xml.append("<Code>" + this.code + "</Code>");
        xml.append("<Type>" + this.type + "</Type>");
        xml.append("<IsItem>" + this.isItem + "</IsItem>");
        xml.append("<Ask>" + this.ask + "</Ask>");
        if (this.items != null) {
            int len = this.items.size();
            for (int i = 0; i < len; ++i) {
                Item thisItem = (Item)this.items.get(i);
                xml.append(thisItem.toFollowOnXml());
            }
        }
        xml.append("</FollowOn>");
        return xml.toString();
    }

    public FollowOn(String followOnXml) {
        this.code = Utility.getElement("Code", followOnXml);
        this.type = Utility.getElement("Type", followOnXml);
        this.isItem = Utility.getBooleanElement("IsItem", followOnXml);
        this.ask = Utility.getBooleanElement("Ask", followOnXml);
        Vector itemsList = Utility.getElementList("FollowonItem", followOnXml);
        int len = itemsList.size();
        if (len > 0) {
            this.items = new ArrayList();
            for (int i = 0; i < len; ++i) {
                String itemXml = (String)itemsList.get(i);
                Item thisItem = new Item(itemXml);
                this.items.add(thisItem);
            }
        }
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONObject followOn = new JSONObject();
        ArrayList itemsArray = new ArrayList();
        try {
            followOn.put("code", (Object)this.code);
            followOn.put("type", (Object)this.type);
            followOn.put("isItem", this.isItem);
            followOn.put("ask", this.ask);
            followOn.put("items", (Collection)this.items);
            jsonObject.put("follow_ons", (Object)followOn);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

