/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.ChoicesPage;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class ChoiceGroup {
    public String name = "";
    public ChoicesPage[] pages = new ChoicesPage[20];

    public ChoiceGroup() {
    }

    public ChoiceGroup(String xml) {
        this.name = Utility.getElement("Name", xml);
        Vector pagesXml = Utility.getElementList("Page", xml);
        int len = pagesXml.size();
        for (int i = 0; i < len; ++i) {
            ChoicesPage thisPage;
            String thisPageXml = (String)pagesXml.get(i);
            this.pages[i] = thisPage = new ChoicesPage(thisPageXml);
        }
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == ChoiceGroup.class) {
            return ((ChoiceGroup)obj).name.compareToIgnoreCase(this.name) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toXml() {
        String xml = "<ChoiceGroup>";
        xml = xml + "<Name>" + this.name + "</Name>";
        int len = this.pages.length;
        for (int i = 0; i < len; ++i) {
            if (this.pages[i] == null) continue;
            xml = xml + this.pages[i].toXml();
        }
        xml = xml + "</ChoiceGroup>";
        return xml;
    }

    public JSONObject toJson() {
        JSONObject keyJsonObject = new JSONObject();
        try {
            keyJsonObject.put("name", (Object)this.name);
            keyJsonObject.put("pages", (Object)this.pages);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return keyJsonObject;
    }
}

