/*
 * Decompiled with CFR 0.152.
 */
package POSDataObjects;

import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.awt.Color;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class Choice {
    public int id = 0;
    public boolean noRepeat = true;
    public String text = "";
    public String display = "";
    public Color textColor = null;
    public Color buttonColor = null;
    public int order = 0;
    public String itemCode = "";
    public boolean cr = true;
    public String[] lines = null;
    public double lineHeight = 0.0;
    public int row = 1;
    public int column = 1;
    public int wide = 1;
    public int high = 1;
    public String imageName = "";
    public boolean noSync = false;
    public Timestamp lastChanged;
    public double price = 0.0;
    public int minRequired = 0;
    public int maxAllowed = 0;

    public Choice() {
    }

    public Choice(String xml) {
        this.id = Utility.getIntElement("Id", xml);
        this.text = Utility.getElement("Text", xml);
        this.display = Utility.getElement("Display", xml);
        this.buttonColor = Utility.colorFromXml(Utility.getElement("ButtonColor", xml));
        this.textColor = Utility.colorFromXml(Utility.getElement("TextColor", xml));
        this.order = Utility.getIntElement("DisplayOrder", xml);
        this.itemCode = Utility.getElement("Item", xml);
        this.cr = Utility.getBooleanElement("Cr", xml);
        this.row = Utility.getIntElement("Row", xml);
        this.column = Utility.getIntElement("Column", xml);
        this.wide = Utility.getIntElement("Wide", xml);
        this.high = Utility.getIntElement("High", xml);
        this.imageName = Utility.getElement("ImageName", xml);
        this.noRepeat = Utility.getBooleanElement("NoRepeat", xml);
        this.noSync = Utility.getBooleanElement("NoSync", xml);
        long lastChangedValue = Utility.getLongElement("LastChanged", xml);
        if (lastChangedValue > 0L) {
            this.lastChanged = new Timestamp(lastChangedValue);
        }
        this.minRequired = Utility.getIntElement("MinRequired", xml);
        this.maxAllowed = Utility.getIntElement("MaxAllowed", xml);
    }

    public String toXml() {
        DecimalFormat decimal = new DecimalFormat("####0.00##;-####0.00##");
        StringBuffer xml = new StringBuffer();
        xml.append("<Choice>");
        xml.append("<Id>" + this.id + "</Id>");
        xml.append("<Text>" + this.text + "</Text>");
        xml.append("<Display>" + this.display + " </Display>");
        xml.append("<ButtonColor>" + Utility.getColorXml(this.buttonColor) + "</ButtonColor>");
        xml.append("<ImageName>" + this.imageName + "</ImageName>");
        xml.append("<TextColor>" + Utility.getColorXml(this.textColor) + "</TextColor>");
        xml.append("<DisplayOrder>" + this.order + "</DisplayOrder>");
        xml.append("<Row>" + this.row + "</Row>");
        xml.append("<Column>" + this.column + "</Column>");
        xml.append("<Wide>" + this.wide + "</Wide>");
        xml.append("<High>" + this.high + "</High>");
        xml.append("<Cr>" + this.cr + "</Cr>");
        xml.append("<Item>" + this.itemCode + "</Item>");
        xml.append("<NoRepeat>" + this.noRepeat + "</NoRepeat>");
        xml.append("    <NoSync>" + this.noSync + "</NoSync>\n");
        if (this.lastChanged != null) {
            xml.append("<LastChanged>" + this.lastChanged.getTime() + "</LastChanged>\r\n");
        }
        xml.append("    <Price>" + decimal.format(this.price) + "</Price>\n");
        xml.append("<MinRequired>" + this.minRequired + "</MinRequired>");
        xml.append("<MaxAllowed>" + this.maxAllowed + "</MaxAllowed>");
        xml.append("</Choice>");
        return xml.toString();
    }

    public Choice(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.row = Utility.getJSONInt(jsonString.toString(), "row");
        this.column = Utility.getJSONInt(jsonString.toString(), "column");
        this.wide = Utility.getJSONInt(jsonString.toString(), "wide");
        this.high = Utility.getJSONInt(jsonString.toString(), "high");
        this.imageName = Utility.getJSONString(jsonString.toString(), "imageName");
        this.itemCode = Utility.getJSONString(jsonString.toString(), "itemCode");
        this.text = Utility.getJSONString(jsonString.toString(), "text");
        this.text = Utility.translateSpecial(this.text);
        this.display = Utility.getJSONString(jsonString.toString(), "text");
        this.display = Utility.translateSpecial(this.display);
        this.cr = Utility.getJSONBoolean(jsonString.toString(), "cr");
        this.noRepeat = Utility.getJSONBoolean(jsonString.toString(), "noRepeat");
        this.noSync = Utility.getJSONBoolean(jsonString.toString(), "noSync");
        this.buttonColor = new Color(0, 0, 0);
        this.textColor = new Color(0, 0, 0);
        this.lastChanged = new Timestamp(System.currentTimeMillis());
    }

    public JSONObject toJson() {
        JSONObject keyJsonObject = new JSONObject();
        try {
            keyJsonObject.put("id", this.id);
            keyJsonObject.put("noRepeat", this.noRepeat);
            keyJsonObject.put("text", (Object)this.text);
            keyJsonObject.put("display", (Object)this.display);
            keyJsonObject.put("order", this.order);
            keyJsonObject.put("itemCode", (Object)this.itemCode);
            keyJsonObject.put("cr", this.cr);
            keyJsonObject.put("lines", (Object)this.lines);
            keyJsonObject.put("row", this.row);
            keyJsonObject.put("column", this.column);
            keyJsonObject.put("imageName", (Object)this.imageName);
            keyJsonObject.put("lineHeight", this.lineHeight);
            keyJsonObject.put("wide", this.wide);
            keyJsonObject.put("high", this.high);
            keyJsonObject.put("noRepeat", this.noRepeat);
            keyJsonObject.put("noSync", this.noSync);
            keyJsonObject.put("lastChanged", this.lastChanged != null ? Long.valueOf(this.lastChanged.getTime()) : JSONObject.NULL);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return keyJsonObject;
    }
}

