/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;

public class XmlTender {
    private String tenderCode = "";
    private String tenderDescription = "";
    private double amount = 0.0;
    private String glAccountNumber = "";
    private String user = "";
    private boolean accountsReceivable = false;
    private String cardNumber = "";
    private String tenderType = "";
    private String country = "";

    public XmlTender(String tenderCode, String tenderDescription, double amount, String glAccountNumber, String user, boolean accountsReceivable, String cardNumber, String tenderType) {
        this.tenderCode = tenderCode;
        this.tenderDescription = tenderDescription;
        this.amount = amount;
        this.glAccountNumber = glAccountNumber;
        this.user = user;
        this.accountsReceivable = accountsReceivable;
        this.cardNumber = cardNumber;
        this.tenderType = tenderType;
    }

    public XmlTender(String xmlString) {
        this.tenderCode = Utility.getElement("tenderCode", xmlString);
        this.tenderDescription = Utility.getElement("tenderDescription", xmlString);
        this.amount = Utility.getDoubleElement("amount", xmlString);
        this.glAccountNumber = Utility.getElement("glAccountNumber", xmlString);
        this.user = Utility.getElement("user", xmlString);
        this.accountsReceivable = Utility.getBooleanElement("accountsReceivable", xmlString, false);
        this.cardNumber = Utility.getElement("cardNumber", xmlString);
        this.tenderType = Utility.getElement("tenderType", xmlString);
    }

    public XmlTender() {
    }

    public void setXmlOutputCountry(String country) {
        this.country = country;
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("      <tender>\r\n");
        xml.append("        <tenderCode>" + this.tenderCode + "</tenderCode>" + "\r\n");
        xml.append("        <tenderDescription>" + this.tenderDescription + "</tenderDescription>" + "\r\n");
        xml.append("        <amount>" + this.amount + "</amount>" + "\r\n");
        xml.append("        <glAccountNumber>" + this.glAccountNumber + "</glAccountNumber>" + "\r\n");
        xml.append("        <user>" + this.user + "</user>" + "\r\n");
        xml.append("        <accountsReceivable>" + this.accountsReceivable + "</accountsReceivable>" + "\r\n");
        if (this.country.equals("IL")) {
            xml.append("        <cardNumber>" + this.cardNumber + "</cardNumber>" + "\r\n");
            xml.append("        <tenderType>" + this.tenderType + "</tenderType>" + "\r\n");
        }
        xml.append("      </tender>\r\n");
        return xml.toString();
    }

    public void setTenderCode(String tenderCode) {
        this.tenderCode = tenderCode;
    }

    public void setTenderDescription(String tenderDescription) {
        this.tenderDescription = tenderDescription;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setGlAccountNumber(String glAccountNumber) {
        this.glAccountNumber = glAccountNumber;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setAccountsReceivable(boolean accountsReceivable) {
        this.accountsReceivable = accountsReceivable;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public void setTenderType(String tenderType) {
        this.tenderType = tenderType;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getTenderCode() {
        return this.tenderCode;
    }

    public String getTenderDescription() {
        return this.tenderDescription;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getGlAccountNumber() {
        return this.glAccountNumber;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isAccountsReceivable() {
        return this.accountsReceivable;
    }

    public String getCountry() {
        return this.country;
    }

    public String getTenderType() {
        return this.tenderType;
    }
}

