/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.XmlInvoice;
import java.util.ArrayList;

public class XmlInvoices {
    private String cashAccount = "";
    private String glDepartment = "";
    private ArrayList invoices = new ArrayList();

    public XmlInvoices(String cashAccount, String glDepartment, ArrayList invoices) {
        this.cashAccount = cashAccount;
        this.glDepartment = glDepartment;
        this.invoices = invoices;
    }

    public XmlInvoices(String xmlString) {
        this.cashAccount = Utility.getElement("cashAccount", xmlString);
        this.glDepartment = Utility.getElement("glDepartment", xmlString);
        ArrayList invoiceStrings = new ArrayList(Utility.getElementList("invoice", xmlString));
        ArrayList<XmlInvoice> invoiceList = new ArrayList<XmlInvoice>();
        int numInvoices = 0;
        if (invoiceStrings != null && !invoiceStrings.isEmpty()) {
            numInvoices = invoiceStrings.size();
        }
        for (int i = 0; i < numInvoices; ++i) {
            String thisInvoiceXml = (String)invoiceStrings.get(i);
            XmlInvoice thisInvoice = new XmlInvoice(thisInvoiceXml);
            invoiceList.add(thisInvoice);
        }
        this.invoices = invoiceList;
    }

    public XmlInvoices() {
    }

    public String toXml() {
        return this.toXml(true);
    }

    public String toXml(boolean legacySupport) {
        StringBuilder xml = new StringBuilder();
        xml.append("<invoices>\r\n");
        xml.append("<cashAccount>" + this.cashAccount + "</cashAccount>" + "\r\n");
        xml.append("<glDepartment>" + this.glDepartment + "</glDepartment>" + "\r\n");
        int numInvoices = 0;
        if (this.invoices != null && !this.invoices.isEmpty()) {
            numInvoices = this.invoices.size();
        }
        for (int i = 0; i < numInvoices; ++i) {
            XmlInvoice thisInvoice = (XmlInvoice)this.invoices.get(i);
            xml.append(thisInvoice.toXml(legacySupport));
        }
        xml.append("</invoices>\r\n");
        return xml.toString();
    }

    public void setCashAccount(String cashAccount) {
        this.cashAccount = cashAccount;
    }

    public void setGlDepartment(String glDepartment) {
        this.glDepartment = glDepartment;
    }

    public void setInvoices(ArrayList invoices) {
        this.invoices = invoices;
    }

    public String getCashAccount() {
        return this.cashAccount;
    }

    public String getGlDepartment() {
        return this.glDepartment;
    }

    public ArrayList getInvoices() {
        return this.invoices;
    }
}

