/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QboPayment {
    public String docNumber;
    public String privateNote;
    public Date transactionDate;
    public double totalAmount;
    public double paymentAmount;
    public String paymentMethodRef;
    public String customerRef;
    public String depositToAccountRef;
    public String linkedJournalRef;
    public String linkedInvoiceRef;
    public String linkedCreditMemoRef;
    public String paymentRef;

    public QboPayment() {
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        xml.append("<Payment xmlns=\"http://schema.intuit.com/finance/v3\" domain=\"QBO\">");
        if (this.transactionDate == null) {
            this.transactionDate = new Date();
        }
        xml.append("<TxnDate>" + dateFormat.format(this.transactionDate) + "</TxnDate>");
        xml.append("<PaymentMethodRef>" + this.paymentMethodRef + "</PaymentMethodRef>");
        if (this.customerRef != null && !this.customerRef.isEmpty()) {
            xml.append("<CustomerRef>" + this.customerRef + "</CustomerRef>");
        }
        xml.append("<TotalAmt>" + this.totalAmount + "</TotalAmt>");
        if (this.docNumber != null && !this.docNumber.isEmpty()) {
            xml.append("<PaymentRefNum>" + this.docNumber + "</PaymentRefNum>");
        }
        if (this.privateNote != null && !this.privateNote.isEmpty()) {
            xml.append("<PrivateNote>" + this.privateNote + "</PrivateNote>");
        }
        xml.append("<DepositToAccountRef>" + this.depositToAccountRef + "</DepositToAccountRef>");
        if (this.paymentAmount != 0.0) {
            xml.append("<Line>");
            xml.append("<Amount>" + this.paymentAmount + "</Amount>");
            if (this.linkedJournalRef != null && !this.linkedJournalRef.isEmpty()) {
                xml.append("<LinkedTxn>");
                xml.append("<TxnId>" + this.linkedJournalRef + "</TxnId>");
                xml.append("<TxnType>JournalEntry</TxnType>");
                xml.append("</LinkedTxn>");
            }
            if (this.linkedInvoiceRef != null && !this.linkedInvoiceRef.isEmpty()) {
                xml.append("<LinkedTxn>");
                xml.append("<TxnId>" + this.linkedInvoiceRef + "</TxnId>");
                xml.append("<TxnType>Invoice</TxnType>");
                xml.append("</LinkedTxn>");
            }
            if (this.linkedCreditMemoRef != null && !this.linkedCreditMemoRef.isEmpty()) {
                xml.append("<LinkedTxn>");
                xml.append("<TxnId>" + this.linkedCreditMemoRef + "</TxnId>");
                xml.append("<TxnType>CreditMemo</TxnType>");
                xml.append("</LinkedTxn>");
            }
            xml.append("</Line>");
        }
        xml.append("</Payment>");
        return xml.toString();
    }

    public QboPayment(String xmlString) {
        this.docNumber = Utility.getElement("DocNumber", xmlString);
        this.customerRef = Utility.getElement("CustomerRef", xmlString);
        String dateXml = Utility.getElement("TxnDate", xmlString);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this.transactionDate = dateFormat.parse(dateXml);
        }
        catch (Exception e) {
            this.transactionDate = null;
        }
    }
}

