/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import java.util.Vector;

public class QboLine {
    public String description;
    public double amount;
    public double unitPrice;
    public double qty;
    public String itemRef;
    public boolean taxable;
    public boolean taxInclusive;
    public double taxInclusiveAmt;
    public String taxCodeRef;
    public String classRef;
    public String detailType;
    public Vector groupLines;

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<Line>");
        xml.append("<Description>" + Utility.encodeString(this.description) + "</Description>");
        xml.append("<Amount>" + this.amount + "</Amount>");
        xml.append("<DetailType>" + this.detailType + "</DetailType>");
        xml.append("<" + this.detailType + ">");
        if (this.detailType != null && this.detailType.contains("GroupLineDetail")) {
            xml.append("<GroupItemRef>" + this.itemRef + "</GroupItemRef>");
        } else {
            xml.append("<ItemRef>" + this.itemRef + "</ItemRef>");
        }
        xml.append("<UnitPrice>" + this.unitPrice + "</UnitPrice>");
        xml.append("<Qty>" + this.qty + "</Qty>");
        if (this.classRef != null && !this.classRef.isEmpty()) {
            xml.append("<ClassRef>" + this.classRef + "</ClassRef>");
        }
        if (this.taxCodeRef == null || this.taxCodeRef.isEmpty()) {
            if (this.taxable) {
                xml.append("<TaxCodeRef>TAX</TaxCodeRef>");
            } else {
                xml.append("<TaxCodeRef>NON</TaxCodeRef>");
            }
        } else {
            xml.append("<TaxCodeRef>" + this.taxCodeRef + "</TaxCodeRef>");
            if (this.taxInclusive) {
                xml.append("<TaxInclusiveAmt>" + this.taxInclusiveAmt + "</TaxInclusiveAmt>");
            }
        }
        if (this.groupLines != null) {
            int numLines = this.groupLines.size();
            for (int i = 0; i < numLines; ++i) {
                QboLine thisLine = (QboLine)this.groupLines.get(i);
                xml.append(thisLine.toXml());
            }
        }
        xml.append("</" + this.detailType + ">");
        xml.append("</Line>");
        return xml.toString();
    }
}

