/*
 * Decompiled with CFR 0.152.
 */
package IntegratorDataObjects;

import AccuServerBase.Utility;
import IntegratorDataObjects.QboLine;
import IntegratorDataObjects.QboTaxLine;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class QboInvoice {
    public String id;
    public String docNumber;
    public String privateNote;
    public Date transactionDate;
    public Date shipDate;
    public Date dueDate;
    public String classRef;
    public String customerRef;
    public String memo;
    public String paymentMethodRef;
    public String depositToAccountRef;
    public boolean taxIncluded;
    public String addressId;
    public String address1;
    public String address2;
    public String city;
    public String state;
    public String zip;
    public String country;
    public Vector invoiceLines = new Vector();
    public String taxCodeRef;
    public double totalTax;
    public Vector taxLines = new Vector();
    public String billEmailAddr;

    public QboInvoice() {
    }

    public QboInvoice(String xmlString) {
        this.id = Utility.getElement("Id", xmlString);
        this.docNumber = Utility.getElement("DocNumber", xmlString);
        this.customerRef = Utility.getElement("CustomerRef", xmlString);
        String dateXml = Utility.getElement("TxnDate", xmlString);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this.transactionDate = dateFormat.parse(dateXml);
        }
        catch (Exception e) {
            this.transactionDate = null;
        }
    }

    public String toXml() {
        StringBuilder xml = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        xml.append("<Invoice xmlns=\"http://schema.intuit.com/finance/v3\" domain=\"QBO\" sparse=\"false\">");
        xml.append("<DocNumber>" + this.docNumber + "</DocNumber>");
        xml.append("<PrivateNote>" + this.privateNote + "</PrivateNote>");
        if (this.transactionDate == null) {
            this.transactionDate = new Date();
        }
        xml.append("<TxnDate>" + dateFormat.format(this.transactionDate) + "</TxnDate>");
        if (this.shipDate == null) {
            this.shipDate = new Date();
        }
        xml.append("<ShipDate>" + dateFormat.format(this.shipDate) + "</ShipDate>");
        if (this.dueDate == null) {
            this.dueDate = new Date();
        }
        xml.append("<DueDate>" + dateFormat.format(this.dueDate) + "</DueDate>");
        if (this.classRef != null && !this.classRef.isEmpty()) {
            xml.append("<ClassRef>" + this.classRef + "</ClassRef>");
        }
        int numLines = this.invoiceLines.size();
        for (int i = 0; i < numLines; ++i) {
            QboLine thisLine = (QboLine)this.invoiceLines.get(i);
            xml.append(thisLine.toXml());
        }
        xml.append("<TxnTaxDetail>");
        xml.append("<TxnTaxCodeRef>" + this.taxCodeRef + "</TxnTaxCodeRef>");
        xml.append("<TotalTax>" + this.totalTax + "</TotalTax>");
        int numTaxLines = this.taxLines.size();
        for (int i = 0; i < numTaxLines; ++i) {
            QboTaxLine thisTaxLine = (QboTaxLine)this.taxLines.get(i);
            xml.append(thisTaxLine.toXml());
        }
        xml.append("</TxnTaxDetail>");
        if (this.customerRef == null) {
            this.customerRef = "";
        }
        xml.append("<CustomerRef>" + this.customerRef + "</CustomerRef>");
        xml.append("<CustomerMemo>" + this.memo + "</CustomerMemo>");
        if (this.address1 != null && !this.address1.isEmpty()) {
            xml.append("<ShipAddr>");
            xml.append("<Line1>" + this.address1 + "</Line1>");
            xml.append("<Line2>" + this.address2 + "</Line2>");
            xml.append("<City>" + this.city + "</City>");
            xml.append("<CountrySubDivisionCode>" + this.state + "</CountrySubDivisionCode>");
            xml.append("<PostalCode>" + this.zip + "</PostalCode>");
            xml.append("</ShipAddr>");
        }
        if (this.paymentMethodRef != null && !this.paymentMethodRef.isEmpty()) {
            xml.append("<PaymentMethodRef>" + this.paymentMethodRef + "</PaymentMethodRef>");
        }
        if (this.depositToAccountRef != null && !this.depositToAccountRef.isEmpty()) {
            xml.append("<DepositToAccountRef>" + this.depositToAccountRef + "</DepositToAccountRef>");
        }
        if (this.taxIncluded) {
            xml.append("<GlobalTaxCalculation>TaxInclusive</GlobalTaxCalculation>");
        } else {
            xml.append("<GlobalTaxCalculation>TaxExcluded</GlobalTaxCalculation>");
        }
        if (this.billEmailAddr != null && !this.billEmailAddr.isEmpty()) {
            xml.append("<EmailStatus>NeedToSend</EmailStatus>");
            xml.append("<BillEmail><Address>" + this.billEmailAddr + "</Address></BillEmail>");
        }
        xml.append("</Invoice>");
        return xml.toString();
    }
}

