/*
 * Decompiled with CFR 0.152.
 */
package AccuCountDataObjects;

import AccuCountDataObjects.InventoryItem;
import AccuCountDataObjects.Vendor;
import AccuServerBase.Utility;
import POSDataObjects.JSONString;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceivingSession {
    public int id = 0;
    public Vendor vendor = null;
    public String poNumber = "";
    public Vector itemList = null;
    public boolean closed = false;
    public Timestamp created = null;
    public Timestamp sentToAccounting = null;
    public String user = null;

    public ReceivingSession() {
    }

    public ReceivingSession(String xml) {
        this.id = Utility.getIntElement("ID", xml);
        this.vendor = new Vendor(Utility.getElement("Vendor", xml));
        this.poNumber = Utility.getElement("PONumber", xml);
        this.closed = Utility.getBooleanElement("Closed", xml);
        long createdTime = Utility.getLongElement("Created", xml);
        this.created = new Timestamp(createdTime);
        long sentTime = Utility.getLongElement("SentToAccounting", xml);
        if (sentTime > 0L) {
            this.sentToAccounting = new Timestamp(sentTime);
        }
        this.user = Utility.getElement("User", xml);
        this.itemList = new Vector();
        String itemsXml = Utility.getElement("ItemList", xml);
        Vector itemListXml = Utility.getElementList("InventoryItem", itemsXml);
        int len = itemListXml.size();
        for (int i = 0; i < len; ++i) {
            String thisItemXml = (String)itemListXml.get(i);
            InventoryItem thisItem = new InventoryItem(thisItemXml);
            this.itemList.add(thisItem);
        }
    }

    public ReceivingSession(JSONString jsonString) {
        this.id = Utility.getJSONInt(jsonString.toString(), "id");
        this.vendor = new Vendor(Utility.getJSONString(jsonString.toString(), "vendor"));
        this.poNumber = Utility.getJSONString(jsonString.toString(), "poNumber");
        this.closed = Utility.getJSONBoolean(jsonString.toString(), "closed");
        String createdString = Utility.getJSONString(jsonString.toString(), "created");
        String sentToAccountingString = Utility.getJSONString(jsonString.toString(), "sentToAccounting");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d,yyyy");
        try {
            this.created = new Timestamp(dateFormat.parse(createdString).getTime());
        }
        catch (Exception e) {
            this.created = null;
        }
        try {
            this.sentToAccounting = new Timestamp(dateFormat.parse(sentToAccountingString).getTime());
        }
        catch (Exception e) {
            this.sentToAccounting = null;
        }
        this.user = Utility.getJSONString(jsonString.toString(), "user");
        String itemsListJson = Utility.getJSONString(jsonString.toString(), "itemsList");
        try {
            JSONArray itemsArray = new JSONArray(itemsListJson);
            int len = itemsArray.length();
            for (int i = 0; i < len; ++i) {
                JSONObject thisItemJson = (JSONObject)itemsArray.get(i);
                InventoryItem thisItem = new InventoryItem(thisItemJson.toString());
                this.itemList.add(thisItem);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toXml() {
        StringBuffer xml = new StringBuffer();
        xml.append("<ReceivingSession>");
        xml.append("<ID>" + this.id + "</ID>");
        xml.append(this.vendor.toXml());
        xml.append("<PONumber>" + this.poNumber + "</PONumber>");
        xml.append("<Closed>" + this.closed + "</Closed>");
        if (this.created != null) {
            xml.append("<Created>" + this.created.getTime() + "</Created>");
        } else {
            xml.append("<Created></Created>");
        }
        if (this.sentToAccounting != null) {
            xml.append("<SentToAccounting>" + this.sentToAccounting.getTime() + "</SentToAccounting>");
        } else {
            xml.append("<SentToAccounting></SentToAccounting>");
        }
        xml.append("<User>" + this.user + "</User>");
        xml.append("<ItemList>");
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                xml.append(thisItem.toXml());
            }
        }
        xml.append("</ItemList>");
        xml.append("</ReceivingSession>");
        return xml.toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", this.id);
            jsonObject.put("vendor", (Object)this.vendor);
            jsonObject.put("poNumber", (Object)this.poNumber);
            jsonObject.put("closed", this.closed);
            jsonObject.put("created", (Object)this.created);
            jsonObject.put("sentToAccounting", (Object)this.sentToAccounting);
            jsonObject.put("user", (Object)this.user);
            JSONArray itemsArray = new JSONArray();
            if (this.itemList != null) {
                int len = this.itemList.size();
                for (int i = 0; i < len; ++i) {
                    InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                    itemsArray.put((Object)thisItem.toJson());
                }
            }
            jsonObject.put("itemsList", (Object)itemsArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public double getVendorTotalReceivedCount() {
        double currentCount = 0.0;
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                currentCount += thisItem.count;
            }
        }
        return currentCount;
    }

    public double getReceivedCountForItem(String itemCode) {
        double currentCount = 0.0;
        if (this.itemList != null) {
            int len = this.itemList.size();
            for (int i = 0; i < len; ++i) {
                InventoryItem thisItem = (InventoryItem)this.itemList.get(i);
                if (thisItem.item == null || thisItem.item.code.compareToIgnoreCase(itemCode) != 0) continue;
                currentCount += thisItem.count;
            }
        }
        return currentCount;
    }

    public void setSentToAccounting() {
        this.sentToAccounting = new Timestamp(new Date().getTime());
        this.closed = true;
    }
}

